<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/sdrfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:ns3="http://www.sec.gov/edgar/sdrcommon">

	<!-- Item 5 templates -->
	<xsl:template name="Item5">
		<h3>
			<em>Signature
			</em>
		</h3>
		<xsl:call-template name="signature" />
	</xsl:template>

	<xsl:template name="signature">
		<table role="presentation" >
			<tr>
				<td class="label">Applicant has duly caused this application, amendment,
					or withdrawal to be signed on its behalf by the undersigned,
					hereunto duly authorized, on this date:
				</td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox2">
								<xsl:value-of select="string(m1:signatureInfo/m1:signatureDate)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
		</table>
		<table role="presentation" >
			<tr>
				<h4>
					<em>
						Applicant and the undersigned hereby represent that all
						information
						contained herein is true, current, and complete.
						Intentional
						misstatements or omissions of fact constitute federal
						criminal
						violations (see 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)). It
						is
						understood that all required items and exhibits are considered
						integral parts of this form and that the submission of any
						amendment or withdrawal represents that all unamended items and
						exhibits remain true, current, and complete as previously filed
						and that the submission of any amendment (other than an annual
						amendment) represents that all unamended information contained in
						items 1 through 17, 26, and 48 remains true, current, and complete
						as filed. If the applicant is a non-resident security-based swap
						data repository, the applicant and the undersigned further
						represent that the applicant can, as a matter of law, and will
						provide the Commission with prompt access to the applicant’s books
						and records and that the applicant can, as a matter of law, and
						will submit to an onsite inspection and examination by the
						Commission. For purposes of this certification, “non-resident
						security-based swap data repository“ means (i) in the case of an
						individual, one who resides in or has his principal place of
						business in any place not in the United States; (ii) in the case
						of a corporation, one incorporated in or having its principal
						place of business in any place not in the United States; or (iii)
						in the case of a partnership or other unincorporated organization
						or association, one having its principal place of business in any
						place not in the United States.
					</em>
				</h4>
			</tr>
			<tr>
				<td class="label">Name of Applicant:  </td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox3">
								<xsl:value-of
									select="string(m1:signatureInfo/m1:signatureApplicantName)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Signature of General Partner, Managing Agent or
					Principal Officer:
				</td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox3">
								<xsl:value-of select="string(m1:signatureInfo/m1:signature)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">Title:  </td>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox3">
								<xsl:value-of select="string(m1:signatureInfo/m1:signatureTitle)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>
			</tr>
			<tr>
				<td class="label">
					Request Confidentiality:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:signatureInfo/m1:signatureConfflag) = 'true'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>